' sap-navigate-back.vbs - Navigate SAP back to main screen after documents are closed

On Error Resume Next

' Declare log file object and path
Dim logFile, logFilePath

' Initialize log file if path is provided
If WScript.Arguments.Count > 0 Then
    logFilePath = WScript.Arguments.Item(0)
    ' Try to open the log file in append mode (8)
    On Error Resume Next
    Set fso = CreateObject("Scripting.FileSystemObject")
    Set logFile = fso.OpenTextFile(logFilePath, 8, True)
    
    If Err.Number <> 0 Then
        WScript.Echo "ERROR: Could not open log file: " & Err.Description
        Err.Clear
        Set logFile = Nothing
    Else
        ' Log script start
        LogToFile "========================================="
        LogToFile "Navigate Back Script Started at " & Now
        LogToFile "========================================="
    End If
End If

' Function to log message to file
Sub LogToFile(message)
    On Error Resume Next
    If Not logFile Is Nothing Then
        logFile.WriteLine Now & " - [" & WScript.ScriptName & "] - " & message
    End If
End Sub

' Function to log message to both console and file
Sub LogMessage(message)
    WScript.Echo message
    LogToFile message
End Sub

' Set scripting mode to true
Set WSHShell = CreateObject("WScript.Shell")

' Disable SAP GUI scripting warnings in registry
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAttach", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnConnection", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAllowListRequired", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\UseAllowList", 0, "REG_DWORD"

' Connect to existing SAP session
If Not IsObject(application) Then
   Set SapGuiAuto  = GetObject("SAPGUI")
   If Err.Number <> 0 Then
       LogMessage "ERROR: Cannot connect to SAP - " & Err.Description
       WScript.Quit 1
   End If
   Set application = SapGuiAuto.GetScriptingEngine
End If

If Not IsObject(connection) Then
   Set connection = application.Children(0)
End If

If Not IsObject(session) Then
   Set session = connection.Children(0)
End If

' Navigate back multiple times to ensure we get to the main screen
' This will handle different depths in the ZPACK transaction
On Error Resume Next
For i = 1 To 3
    session.findById("wnd[0]/tbar[0]/btn[3]").press
    WScript.Sleep 300
Next

LogMessage "SUCCESS: SAP navigation completed"

' Add at the end of your script before it exits
Sub CloseLogFile()
    On Error Resume Next
    If Not logFile Is Nothing Then
        LogToFile "Script ended at " & Now
        LogToFile "========================================="
        logFile.Close
        Set logFile = Nothing
    End If
End Sub

CloseLogFile()